# URLs below can contain project / group URLs, but have to fit as this script
# does a very simple search and replace.
# Backup first
old_gitlab_url = 'https://git.my-old.domain/'
new_gitlab_url = 'https://git.my-new.domain/'

Ticket.where("preferences LIKE '%gitlab%'").find_in_batches.each do |b|
   b.each do |t|
      next if t.preferences[:gitlab][:issue_links].count.zero?

      # Evaluate array for current data
      no_issue_links = t.preferences[:gitlab][:issue_links].count
      issue_link_hits = 0

      t.preferences[:gitlab][:issue_links].each do |p|
         next unless p.include? new_gitlab_url

         issue_link_hits += 1
         puts "issue_link_hits #{issue_link_hits} / #{no_issue_links}"
      end

      next if issue_link_hits == no_issue_links

      # Move fast, break everything
      puts "Touching Ticket# #{t.number} ..."
      t.preferences[:gitlab][:issue_links].each do |p|
         next unless p.include? old_gitlab_url

         old_url = p
         new_url = p.sub!(old_gitlab_url, new_gitlab_url)

         puts "...  Changed #{old_url} to #{new_url}"
      end

      t.save!
   end
end; nil
