# URLs below can contain project / group URLs, but have to fit as this script
# does a very simple search and replace.
# Backup first
old_github_url = 'https://git.my-old.domain/'
new_github_url = 'https://git.my-new.domain/'

Ticket.where("preferences LIKE '%github%'").find_in_batches.each do |b|
   b.each do |t|
      next if t.preferences[:github][:issue_links].count.zero?

      # Evaluate array for current data
      no_issue_links = t.preferences[:github][:issue_links].count
      issue_link_hits = 0

      t.preferences[:github][:issue_links].each do |p|
         next unless p.include? new_github_url

         issue_link_hits += 1
         puts "issue_link_hits #{issue_link_hits} / #{no_issue_links}"
      end

      next if issue_link_hits == no_issue_links

      # Move fast, break everything
      puts "Touching Ticket# #{t.number} ..."
      t.preferences[:github][:issue_links].each do |p|
         next unless p.include? old_github_url

         old_url = p
         new_url = p.sub!(old_github_url, new_github_url)

         puts "...  Changed #{old_url} to #{new_url}"
      end

      t.save!
   end
end; nil
