# Enables existing Email channels to verify SSL certificates
# (Below command PROBES inbound and outbound and only activates ssl verification if true!)
# Has been enhanced with the help of rolfschmidt

Channel.where(area: 'Email::Account', active: true).all.select do |c| 
  c.options.dig('inbound', 'options', 'ssl_verify') == false || c.options.dig('outbound', 'options', 'ssl_verify') == false
end.each do |c|
  if %[imap smtp pop3].include?(c.options.dig('inbound', 'adapter')) && c.options.dig('inbound', 'options', 'ssl_verify') == false
    c.options['inbound']['options']['ssl_verify'] = true
    inbound_result = EmailHelper::Probe.inbound(c.options['inbound'])
    puts "INBOUND | channel #{c.id} (#{c.options.dig('inbound', 'options', 'host')}, #{c.options.dig('inbound', 'options', 'user')}) | try SSL verify true, RESULT: #{inbound_result[:result]}"

    if inbound_result[:result] == 'ok'
      c.options['inbound'][:options][:ssl_verify] = true
      c.save!
    else
      puts " - DEBUG - response: #{inbound_result[:message]}; human message: #{inbound_result[:message_human]}; possibly invalid fields: #{inbound_result[:invalid_field]}"
    end
  end
  if %[imap smtp pop3].include?(c.options.dig('inbound', 'adapter')) && c.options.dig('outbound', 'options', 'ssl_verify') == false
    outbound_result = EmailHelper::Probe.outbound(
      c.options['outbound'],
      'verify-external-smtp-sending@discard.zammad.org',
      'Zammad Probe Outbound',
    )
    puts "OUTBOUND | channel #{c.id} (#{c.options.dig('outbound', 'options', 'host')}, #{c.options.dig('outbound', 'options', 'user')}) | try SSL verify true, RESULT: #{outbound_result[:result]}"

    if outbound_result[:result] == 'ok'
      c.options['outbound'][:options][:ssl_verify] = true
      c.save!
    else
      puts " - DEBUG - response: #{outbound_result[:message]}; human message: #{outbound_result[:message_human]}; possibly invalid fields: #{outbound_result[:invalid_field]}"
    end
  end
end; nil

# Enable SSL certificate verification for i-doit integration
# (MAY break i-doit functionality if certificates are invalid!)

config = Setting.get('idoit_config')
unless config.blank? ; then Setting.set('idoit_config', config.merge('verify_ssl' => true)) end
