# Set elastic user password and ReadOnly password for the to be created Grafana user
es_password=''
ro_password=''

# Create Elasticsearch Role
# names 'zammad_' is the default prefix and might be different in your environment!
curl --insecure -uelastic:"${es_password}" -H 'Content-Type: application/json' 'https://localhost:9200/_security/role/zammad_grafana_ro' -d '{
  "cluster" : [ "monitor" ],
  "indices" : [
    {
      "names" : [ "zammad_" ],
      "privileges" : [ "monitor", "read", "view_index_metadata" ]
    }
  ]
}'

# Create Elasticsearch ReadOnly User
curl --insecure -uelastic:"${es_password}" -H 'Content-Type: application/json' 'https://localhost:9200/_security/user/zammad_grafana' -d "{
  \"password\" : \"${ro_password}\",
  \"full_name\" : \"Grafana ReadOnly Account for Zammad\",
  \"roles\" : [ \"zammad_grafana_ro\" ]
}"
