# As documented on original Grafana documentation:
# https://grafana.com/docs/grafana/latest/setup-grafana/installation/debian/

# Add Debian repository
mkdir -p /etc/apt/keyrings/
wget -q -O - https://apt.grafana.com/gpg.key | gpg --dearmor | tee /etc/apt/keyrings/grafana.gpg > /dev/null
echo "deb [signed-by=/etc/apt/keyrings/grafana.gpg] https://apt.grafana.com stable main" | tee -a /etc/apt/sources.list.d/grafana.list

# Install Grafana Enterprise (as suggested)
apt install grafana-enterprise

# Use below sed commands to adjust your configuration file -or- copy below grafana.ini and replace it with your local one
sed -i 's/;http_port = 3000/http_port = 3001/g' /etc/grafana/grafana.ini
sed -i 's/;http_addr =/http_addr = 127.0.0.1/g' /etc/grafana/grafana.ini
sed -i 's/;instance_name = localhost/instance_name = FQDN/g' /etc/grafana/grafana.ini
sed -i 's/;domain = localhostdomain = localhost/domain = FQDN/g' /etc/grafana/grafana.ini
sed -i 's/;enforce_domain = false/enforce_domain = true/g' /etc/grafana/grafana.ini
sed -i 's/;root_url = %(protocol)s:\/\/%(domain)s:%(http_port)s\//root_url = %(protocol)s:\/\/%(domain)s\//g' /etc/grafana/grafana.ini
sed -i 's/;content_security_policy = false/content_security_policy = true/g' /etc/grafana/grafana.ini
sed -i 's/;cookie_secure = false/cookie_secure = true/g' /etc/grafana/grafana.ini
sed -i 's/;cookie_samesite = lax/cookie_samesite = strict/g' /etc/grafana/grafana.ini
echo "content_security_policy_template = \"\"\"script-src 'self' 'unsafe-eval' 'unsafe-inline' 'strict-dynamic' $NONCE;object-src 'none';font-src 'self';style-src 'self' 'unsafe-inline' blob:;img-src * data:;base-uri 'self';connect-src 'self' grafana.com ws://$ROOT_PATH wss://$ROOT_PATH;manifest-src 'self';media-src 'none';form-action 'self';frame-src: 'self'\"\"\"" >> /etc/grafana/grafana.ini
sed -i 's/;allow_sign_up = true/allow_sign_up = false/g' /etc/grafana/grafana.ini
sed -i 's/;hide_version = false/hide_version = true/g' /etc/grafana/grafana.ini

# After you're done with your configuration, start and enable Grafana
systemctl enable grafana-server --now