# List all snapshots of the backup repository
restic -r s3:https://s3.domain.tld/resticsample

# List files in your backup
restic -r s3:https://s3.domain.tld/resticsample ls --long latest /opt/zammad/config/

# Mount your backup for easier search of files all over all snapshots
# (technically works for restore too, but slower)
restic -r s3:https://s3.domain.tld/resticsample mount /mnt/

# Apply snapshot hold policy and remove snapshots older than defined rules
restic -r s3:https://s3.domain.tld/resticsample forget --group-by '' --keep-hourly 1 --keep-daily 14 --prune

# Read 25% of your backup to verify its integrity
restic -r s3:https://s3.domain.tld/resticsample check --read-data-subset=25%
# Do it on 100% of your backup
restic -r s3:https://s3.domain.tld/resticsample check

# Change the current password of a repository key
restic -r s3:https://s3.domain.tld/resticsample key passwd

# Add further keys to your repository
restic -r s3:https://s3.domain.tld/resticsample key add

# List all configured keys
restic -r s3:https://s3.domain.tld/resticsample key list

# Remove a certain key ID (from previous list)
restic -r s3:https://s3.domain.tld/resticsample key remove <id>

# Unlock a locked backup repository
restic -r s3:https://s3.domain.tld/resticsample unlock
