# (environment) variables you need
export AWS_ACCESS_KEY_ID="s3-username"
export AWS_SECRET_ACCESS_KEY="s3-password"
export RESTIC_PASSWORD="password"

# initialize Minio Backup Repository
restic -r s3:https://s3.domain.tld/resticsample init

# Export PostGreSQL Dump of Zammad database
sudo -u postgres pg_dump --dbname zammad --no-privileges --no-owner >> /tmp/zammad.psql

# Backup complete Zammad directory with database dump
restic -r s3:https://s3.domain.tld/resticsample migrate
restic --no-scan --read-concurrency=25 --pack-size=128 --compression off -r s3:https://s3.domain.tld/resticsample backup --exclude "/opt/zammad/tmp/*" /opt/zammad/ /tmp/zammad.psql

# Restore a PostGreSQL Dump from Repo
restic -r s3:https://s3.domain.tld/resticsample dump latest '/tmp/zammad.psql' | sudo -u postgres psql zammad

# Restore Zammad filesystem
restic -r s3:https://s3.domain.tld/resticsample restore latest --include /opt/zammad/ --target /
